<?php
/*
 +-------------------------------------------------------------------------+
 | Copyright (C) 2006-2022 The Cacti Group                                 |
 |                                                                         |
 | This program is free software; you can redistribute it and/or           |
 | modify it under the terms of the GNU General Public License             |
 | as published by the Free Software Foundation; either version 2          |
 | of the License, or (at your option) any later version.                  |
 |                                                                         |
 | This program is distributed in the hope that it will be useful,         |
 | but WITHOUT ANY WARRANTY; without even the implied warranty of          |
 | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           |
 | GNU General Public License for more details.                            |
 +-------------------------------------------------------------------------+
 | Cacti: The Complete RRDTool-based Graphing Solution                     |
 +-------------------------------------------------------------------------+
 | This code is designed, written, and maintained by the Cacti Group. See  |
 | about.php and/or the AUTHORS file for specific developer information.   |
 +-------------------------------------------------------------------------+
 | http://www.cacti.net/                                                   |
 +-------------------------------------------------------------------------+
*/

function thold_draw_navigation_text($nav) {
	global $config;

	$nav['thold.php:'] = array(
		'title' => __('Thresholds', 'thold'),
		'mapping' => 'index.php:',
		'url' => 'thold.php',
		'level' => '1'
	);

	$nav['thold.php:actions'] = array(
		'title' => __('(actions)', 'thold'),
		'mapping' => 'index.php:,thold.php:',
		'url' => 'thold.php',
		'level' => '2'
	);

	$nav['thold.php:edit'] = array(
		'title' => __('(edit)', 'thold'),
		'mapping' => 'index.php:,thold.php:',
		'url' => 'thold.php',
		'level' => '2'
	);

	$nav['thold.php:save'] = array(
		'title' => __('(save)', 'thold'),
		'mapping' => 'index.php:,thold.php:',
		'url' => 'thold.php',
		'level' => '2'
	);

	$nav['thold.php:add'] = array(
		'title' => __('(add)', 'thold'),
		'mapping' => 'index.php:,thold.php:',
		'url' => 'thold.php',
		'level' => '2'
	);

	$nav['thold.php:autocreate'] = array(
		'title' => __('Thresholds', 'thold'),
		'mapping' => 'index.php:',
		'url' => 'thold.php',
		'level' => '2'
	);

	$nav['thold_graph.php:'] = array(
		'title' => __('Thresholds', 'thold'),
		'mapping' => '',
		'url' => 'thold_graph.php',
		'level' => '0'
	);
	$nav['thold_graph.php:thold'] = array(
		'title' => __('Thresholds', 'thold'),
		'mapping' => '',
		'url' => 'thold_graph.php',
		'level' => '0'
	);

	$nav['thold_graph.php:log'] = array(
		'title' => __('Threshold Logs', 'thold'),
		'mapping' => '',
		'url' => 'thold_graph.php',
		'level' => '0'
	);

	$nav['thold_graph.php:hoststat'] = array(
		'title' => __('Device Status', 'thold'),
		'mapping' => '',
		'url' => 'thold_graph.php',
		'level' => '0'
	);

	$nav['thold_view_failures.php:'] = array(
		'title' => __('Thresholds - Failures', 'thold'),
		'mapping' => 'index.php:',
		'url' => 'thold_view_failures.php',
		'level' => '1'
	);

	$nav['thold_view_normal.php:'] = array(
		'title' => __('Thresholds - Normal', 'thold'),
		'mapping' => 'index.php:',
		'url' => 'thold_view_normal.php',
		'level' => '1'
	);

	$nav['thold_view_recover.php:'] = array(
		'title' => __('Thresholds - Recovering', 'thold'),
		'mapping' => 'index.php:',
		'url' => 'thold_view_recover.php',
		'level' => '1'
	);
	$nav['thold_view_recent.php:'] = array(
		'title' => __('Recent Thresholds', 'thold'),
		'mapping' => 'index.php:',
		'url' => 'thold_view_recent.php',
		'level' => '1'
	);

	$nav['thold_view_host.php:'] = array(
		'title' => __('Recent Device Failures', 'thold'),
		'mapping' => 'index.php:',
		'url' => 'thold_view_host.php',
		'level' => '1'
	);

	$nav['thold_templates.php:'] = array(
		'title' => __('Threshold Templates', 'thold'),
		'mapping' => 'index.php:',
		'url' => 'thold_templates.php',
		'level' => '1'
	);

	$nav['thold_templates.php:edit'] = array(
		'title' => __('Threshold Templates', 'thold'),
		'mapping' => 'index.php:',
		'url' => 'thold_templates.php',
		'level' => '1'
	);

	$nav['thold_templates.php:save'] = array(
		'title' => __('Threshold Templates', 'thold'),
		'mapping' => 'index.php:',
		'url' => 'thold_templates.php',
		'level' => '1'
	);

	$nav['thold_templates.php:add'] = array(
		'title' => __('Threshold Templates', 'thold'),
		'mapping' => 'index.php:',
		'url' => 'thold_templates.php',
		'level' => '1'
	);

	$nav['thold_templates.php:actions'] = array(
		'title' => __('Threshold Templates', 'thold'),
		'mapping' => 'index.php:',
		'url' => 'thold_templates.php',
		'level' => '1'
	);

	$nav['thold_templates.php:import'] = array(
		'title' => __('Threshold Template Import', 'thold'),
		'mapping' => 'index.php:',
		'url' => 'thold_templates.php',
		'level' => '2'
	);

	$nav['notify_lists.php:'] = array(
		'title' => __('Notification Lists', 'thold'),
		'mapping' => 'index.php:',
		'url' => 'notify_lists.php',
		'level' => '1'
	);

	$nav['notify_lists.php:edit'] = array(
		'title' => __('Notification Lists (edit)', 'thold'),
		'mapping' => 'index.php:',
		'url' => 'notify_lists.php',
		'level' => '1'
	);

	$nav['notify_lists.php:save'] = array(
		'title' => __('Notification Lists', 'thold'),
		'mapping' => 'index.php:',
		'url' => 'notify_lists.php',
		'level' => '1'
	);

	$nav['notify_lists.php:actions'] = array(
		'title' => __('Notification Lists', 'thold'),
		'mapping' => 'index.php:',
		'url' => 'notify_lists.php',
		'level' => '1'
	);

	return $nav;
}

function thold_config_insert() {
	global $menu;

	$menu[__('Management')]['plugins/thold/notify_lists.php']   = __('Notification Lists', 'thold');
	$menu[__('Management')]['plugins/thold/thold.php']          = __('Thresholds', 'thold');
	$menu[__('Templates')]['plugins/thold/thold_templates.php'] = __('Threshold', 'thold');

	if (isset_request_var('thold_vrule')) {
		if (get_nfilter_request_var('thold_vrule') == 'on') {
			$_SESSION['sess_config_array']['thold_draw_vrules'] = 'on';
			$_SESSION['sess_config_array']['boost_png_cache_enable'] = false;
		} elseif (get_nfilter_request_var('thold_vrule') == '') {
			$_SESSION['sess_config_array']['thold_draw_vrules'] = '';
		}
	}

	if (!defined('ST_RESTORAL')) {
		define('ST_RESTORAL', 0); // Restoral
		define('ST_TRIGGERA', 1); // Trigger Alert
		define('ST_NOTIFYRA', 2); // Notify Alert Retrigger
		define('ST_NOTIFYWA', 3); // Notify Warning
		define('ST_NOTIFYAL', 4); // Notify Alert
		define('ST_NOTIFYRS', 5); // Notify Restoral
		define('ST_TRIGGERW', 6); // Trigger Warning
		define('ST_NOTIFYAW', 7); // Notify Restoral to Warning
	}

	if (!defined('MESSAGE_LEVEL_NONE')) {
		define('MESSAGE_LEVEL_NONE', 0);
		define('MESSAGE_LEVEL_INFO', 1);
		define('MESSAGE_LEVEL_WARN', 2);
		define('MESSAGE_LEVEL_ERROR', 3);
		define('MESSAGE_LEVEL_CSRF', 4);
	}

	if (!defined('STAT_HI')) {
		define('STAT_HI', 2);
		define('STAT_LO', 1);
		define('STAT_NORMAL', 0);
	}

	if (!defined('THOLD_SEVERITY_NORMAL')) {
		define('THOLD_SEVERITY_NORMAL', 0);
		define('THOLD_SEVERITY_ALERT', 1);
		define('THOLD_SEVERITY_WARNING', 2);
		define('THOLD_SEVERITY_NOTICE', 3);
		define('THOLD_SEVERITY_ACKREQ', 4);
		define('THOLD_SEVERITY_DISABLED', 5);
		define('THOLD_SEVERITY_BASELINE', 6);
	}
}

function thold_config_arrays() {
	global $config, $messages;

	$messages['thold_save'] = array(
		'message' => __('A template with that Data Source already exists!', 'thold'),
		'type' => 'error'
	);

	if (isset($_SESSION['thold_message']) && $_SESSION['thold_message'] != '') {
		$messages['thold_message'] = array(
			'message' => $_SESSION['thold_message'],
			'type' => 'info'
		);
	}

	$realm_array = array(
		__('Configure Thresholds', 'thold'),
		__('Configure Threshold Templates', 'thold'),
		__('Manage Notification Lists', 'thold'),
		__('View Thresholds', 'thold')
	);

	if (function_exists('auth_augment_roles')) {
		auth_augment_roles(__('Normal User'), array('thold_graph.php'));
		auth_augment_roles(__('Template Editor'), array('thold_templates.php'));
		auth_augment_roles(__('General Administration'), array('thold.php'));
		auth_augment_roles(__('General Administration'), array('notify_lists.php'));
	}

	kill_session_var('thold_message');
}

function thold_config_form() {
	global $fields_host_edit;

	$fields_host_edit2 = $fields_host_edit;
	$fields_host_edit3 = array();

	foreach ($fields_host_edit2 as $f => $a) {
		$fields_host_edit3[$f] = $a;

		if ($f == 'disabled') {
			$fields_host_edit3['thold_mail_spacer'] = array(
				'friendly_name' => __('Device Up/Down Notification Settings', 'thold'),
				'method' => 'spacer',
				'collapsible' => true
			);

			$fields_host_edit3['thold_send_email'] = array(
				'friendly_name' => __('Threshold Up/Down Email Notification', 'thold'),
				'method' => 'drop_array',
				'array' =>  array(
					'0' => __('Disabled', 'thold'),
					'1' => __('Global List', 'thold'),
					'2' => __('List Below', 'thold'),
					'3' => __('Global and List Below', 'thold')
				),
				'description' => __('Which Notification List(s) of should be notified about Device Up/Down events?', 'thold'),
				'value' => '|arg1:thold_send_email|',
				'on_change' => 'changeNotify()',
				'default' => '0',
				'form_id' => false
			);

			$fields_host_edit3['thold_host_email'] = array(
				'friendly_name' => __('Notification List', 'thold'),
				'description' => __('Additional Email address, separated by commas for multiple Emails.', 'thold'),
				'method' => 'drop_sql',
				'sql' => 'SELECT id,name FROM plugin_notification_lists ORDER BY name',
				'value' => '|arg1:thold_host_email|',
				'default' => '',
				'none_value' => 'None'
			);

			$fields_host_edit3['thold_failure_count'] = array(
				'friendly_name' => __('Host Failure Count', 'thold'),
				'description' => __('The number of Polling Intervals at this Host must be Down before Thold logging an error and reporting Host as Down. Default is 0 (use Cacti setting)', 'thold'),
				'method' => 'drop_array',
				'value' => '|arg1:thold_failure_count|',
				'default' => '0',
				'array' => array(
					0 => __('Use Cacti Setting', 'thold'),
					1 => __('%d Polling Interval', 1, 'thold'),
					2 => __('%d Polling Intervals', 2, 'thold'),
					3 => __('%d Polling Intervals', 3, 'thold'),
					4 => __('%d Polling Intervals', 4, 'thold'),
					5 => __('%d Polling Intervals', 5, 'thold')
				)
			);
		}
	}

	$fields_host_edit = $fields_host_edit3;
}

function thold_config_settings() {
	global $tabs, $settings, $item_rows, $config, $syslog_facil_array, $syslog_priority_array;

	if (get_current_page() != 'settings.php') return;

	include($config['base_path'] . '/plugins/thold/includes/arrays.php');
	include_once($config['base_path'] . '/plugins/thold/setup.php');
	include_once($config['base_path'] . '/plugins/thold/thold_functions.php');
	include_once($config['base_path'] . '/plugins/thold/includes/database.php');

	/* check to see if there is an upgrade required */
	plugin_thold_upgrade();

	$tabs['alerts'] = __('Alerting/Thold', 'thold');

	if (isset($settings['alerts'])) {
		$temp = $settings['alerts'];
	}

	$settings['alerts'] = array(
		'general_header' => array(
			'friendly_name' => __('General', 'thold'),
			'method' => 'spacer',
		),
		'thold_disable_all' => array(
			'friendly_name' => __('Disable All Thresholds', 'thold'),
			'description' => __('Checking this box will disable Alerting on all Thresholds.  This can be used when it is necessary to perform maintenance on your network.', 'thold'),
			'method' => 'checkbox',
			'default' => ''
		),
		'thold_autocreate' => array(
			'friendly_name' => __('Auto Create Thresholds', 'thold'),
			'description' => __('If selected, when running either automation, or when creating/saving a Device, all Thresholds associated with the Device Template will be created.', 'thold'),
			'method' => 'checkbox',
			'default' => ''
		),
		'thold_disable_legacy' => array(
			'friendly_name' => __('Disable Legacy Notifications', 'thold'),
			'description' => __('Checking this box will disable Legacy Alerting on all Thresholds.  Legacy Alerting is defined as any Specific Email Alerts not associated with a Notification List.', 'thold'),
			'method' => 'checkbox',
			'default' => ''
		),
		'notify_templated' => array(
			'friendly_name' => __('Threshold Notification Templated', 'thold'),
			'description' => __('If checked, when creating at Threshold Template, its Notification Settings will, by default be owned by the Threshold Template.', 'thold'),
			'method' => 'checkbox'
		),
		'thold_enable_scripts' => array(
			'friendly_name' => __('Enable Command Execution', 'thold'),
			'description' => __('Checking this box will enable the ability to run commands on Threshold breach and restoral events.', 'thold'),
			'method' => 'checkbox',
			'default' => ''
		),
		'thold_enable_per_thold_body' => array(
			'friendly_name' => __('Enable Per Thold Notification', 'thold'),
			'description' => __('Checking this box will enable the ability to maintain custom Email bodies for Thresholds.', 'thold'),
			'method' => 'checkbox',
			'default' => ''
		),
		'thold_consider_unknown_zero' => array(
			'friendly_name' => __('Consider Unknown Data as Zero', 'thold'),
			'description' => __('When checking Thresholds, if a Data Source returns Unknown Data (\'U\'), consider the value as zero for the Threshold check.', 'thold'),
			'method' => 'checkbox',
			'default' => ''
		),
		'thold_filter_default' => array(
			'friendly_name' => __('Default Management Status', 'thold'),
			'description' => __('Default Threshold management filter status.', 'thold'),
			'method' => 'drop_array',
			'array' => array(
				'-1' => __('Any', 'thold'),
				'0'  => __('Disabled', 'thold'),
				'2'  => __('Enabled', 'thold'),
				'1'  => __('Breached', 'thold'),
				'3'  => __('Triggered', 'thold')
			),
			'default' => -1
		),
		'thold_monitor_default' => array(
			'friendly_name' => __('Default Monitor Status', 'thold'),
			'description' => __('Default Threshold Tab filter status.', 'thold'),
			'method' => 'drop_array',
			'array' => array(
				'-1' => __('Any', 'thold'),
				'0'  => __('Disabled', 'thold'),
				'2'  => __('Enabled', 'thold'),
				'1'  => __('Breached', 'thold'),
				'3'  => __('Triggered', 'thold')
			),
			'default' => -1
		),
		'thold_empty_if_speed_default' => array(
			'friendly_name' => __('Empty ifHighSpeed Default', 'thold'),
			'description' => __('When calculating Expression Thresholds, if the ifHighSpeed and ifSpeed come back as zero, use the following ifHighSpeed setting instead.  Default ifHighSpeed will be 10000 for 10GE interfaces.', 'thold'),
			'method' => 'textbox',
			'size' => 6,
			'max_length' => 6,
			'default' => '10000'
		),
		'daemon_header' => array(
			'friendly_name' => __('Threshold Daemon', 'thold'),
			'method' => 'spacer',
		),
		'thold_daemon_enable' => array(
			'friendly_name' => __('Enable Threshold Daemon', 'thold'),
			'description' => __('Checking this box will enable the use of a dedicated Threshold daemon. This can be used to increase system performance and/or to distribute Threshold monitoring to a separate server.', 'thold'),
			'method' => 'checkbox',
			'default' => ''
		),
		'thold_daemon_debug' => array(
			'friendly_name' => __('Force Threshold Daemon Debug', 'thold'),
			'description' => __('Checking this box will enable Threshold Daemon debug when operating from SystemD or through the command line.  This change is dynamic and will take effect as soon as the next Threshold loop commences.', 'thold'),
			'method' => 'checkbox',
			'default' => ''
		),
		'thold_daemon_dead_notification' => array(
			'friendly_name' => __('Daemon Down Notification Frequency', 'thold'),
			'description' => __('If the Thold Daemon is found to be down, send out an Email notification at this frequency.', 'thold'),
			'method' => 'drop_array',
			'array' => array(
				'-1'   => __('Disabled', 'thold'),
				'600'  => __('Every %d Minutes', 10, 'thold'),
				'1200'  => __('Every %d Minutes', 20, 'thold'),
				'2400'  => __('Every %d Minutes', 40, 'thold'),
				'3600'  => __('Every %d Hour', 1, 'thold'),
				'7200'  => __('Every %d Hours', 2, 'thold')
			),
			'default' => 7200
		),
		'thold_max_concurrent_processes' => array(
			'friendly_name' => __('Daemon Threads', 'thold'),
			'description' => __('The number of daemon threads to be handled by the Threshold Daemon.', 'thold'),
			'method' => 'drop_array',
			'array' => array(
				'1'  => __('1 Process', 'thold'),
				'2'  => __('%d Processes', 2, 'thold'),
				'3'  => __('%d Processes', 3, 'thold'),
				'4'  => __('%d Processes', 4, 'thold'),
				'5'  => __('%d Processes', 5, 'thold'),
				'6'  => __('%d Processes', 6, 'thold'),
				'7'  => __('%d Processes', 7, 'thold'),
				'8'  => __('%d Processes', 8, 'thold'),
				'9'  => __('%d Processes', 9, 'thold'),
				'10' => __('%d Processes', 10, 'thold')
			),
			'default' => read_config_option('concurrent_processes')
		),
		'logging_header' => array(
			'friendly_name' => __('Logging', 'thold'),
			'method' => 'spacer',
		),
		'thold_log_cacti' => array(
			'friendly_name' => __('Log Threshold Breaches', 'thold'),
			'description' => __('Enable logging of all Threshold failures to the Cacti Log.', 'thold'),
			'method' => 'checkbox',
			'default' => ''
		),
		'thold_show_datasource' => array(
			'friendly_name' => __('Show Data Source in Log', 'thold'),
			'description' => __('Show the Data Source name in the Log if not present.', 'thold'),
			'method' => 'checkbox',
			'default' => ''
		),
		'thold_log_changes' => array(
			'friendly_name' => __('Log Threshold Changes', 'thold'),
			'description' => __('Enable logging of all Threshold changes to the Cacti Log.', 'thold'),
			'method' => 'checkbox',
			'default' => ''
		),
		'thold_log_debug' => array(
			'friendly_name' => __('Debug Log', 'thold'),
			'description' => __('Enable logging of debug messages with Threshold', 'thold'),
			'method' => 'checkbox',
			'default' => ''
		),
		'thold_log_storage' => array(
			'friendly_name' => __('Alert Log Retention', 'thold'),
			'description' => __('Keep Threshold Logs for this number of days.', 'thold'),
			'method' => 'drop_array',
			'default' => '31',
			'array' => $thold_log_retention
		),
		'syslog_header' => array(
			'friendly_name' => __('Syslog Settings', 'thold'),
			'method' => 'spacer',
		),
		'alert_syslog' => array(
			'friendly_name' => __('Syslog Enabled', 'thold'),
			'description' => __('If checked, when creating a new Threshold, by default new Threshold events will be sent to your local syslog.  This setting is a preset.  Threshold settings dictate actual syslog control.', 'thold'),
			'method' => 'checkbox'
		),
		'thold_syslog_priority' => array(
			'friendly_name' => __('Default Priority/Level', 'thold'),
			'description' => __('This is the default Priority/Level that Thold will use to send syslog messages.  This setting is a preset.  Threshold settings dictate actual syslog control.', 'thold'),
			'method' => 'drop_array',
			'default' => $default_priority,
			'array' => $syslog_priority_array,
		),
		'thold_syslog_facility' => array(
			'friendly_name' => __('Default Facility', 'thold'),
			'description' => __('This is the default Facility that Thold will use to send syslog messages.  This setting is a preset.  Threshold settings dictate actual syslog control.', 'thold'),
			'method' => 'drop_array',
			'default' => $default_facility,
			'array' => $syslog_facil_array,
		),
		'thold_alerting_header' => array(
			'friendly_name' => __('Alert Presets', 'thold'),
			'method' => 'spacer',
		),
		'alert_exempt' => array(
			'friendly_name' => __('Weekend exemptions', 'thold'),
			'description' => __('If this is checked, Thold will not run on weekends.', 'thold'),
			'method' => 'checkbox',
		),
		'alert_trigger' => array(
			'friendly_name' => __('Default Trigger Count', 'thold'),
			'description' => __('Default number of consecutive times the Data Source must be in breach of the Threshold for an Alert to be raised.', 'thold'),
			'method' => 'textbox',
			'size' => 4,
			'max_length' => 4,
			'default' => 1
		),
		'alert_repeat' => array(
			'friendly_name' => __('Re-Alerting', 'thold'),
			'description' => __('Repeat Alert after specified number of poller cycles.', 'thold'),
			'method' => 'textbox',
			'size' => 4,
			'max_length' => 4,
			'default' => 12
		),
		'thold_baseline_header' => array(
			'friendly_name' => __('Baseline Presets', 'thold'),
			'method' => 'spacer',
		),
		'alert_bl_timerange_def' => array(
			'friendly_name' => __('Baseline Time Range Default', 'thold'),
			'description' => __('This is the default value used in creating Thresholds or templates.', 'thold'),
			'method' => 'drop_array',
			'array' => get_reference_types(),
			'size' => 12,
			'max_length' => 12,
			'default' => 86400
		),
		'alert_bl_trigger' => array(
			'friendly_name' => __('Baseline Trigger Count', 'thold'),
			'description' => __('Default number of consecutive times the Data Source must be in breach of the calculated Baseline Threshold for an Alert to be raised.', 'thold'),
			'method' => 'textbox',
			'size' => 4,
			'max_length' => 4,
			'default' => 2
		),
		'alert_bl_percent_def' => array(
			'friendly_name' => __('Baseline Deviation Percentage', 'thold'),
			'description' => __('This is the default value used in creating Thresholds or templates.', 'thold'),
			'method' => 'textbox',
			'size' => 3,
			'max_length' => 3,
			'default' => 20
		),
		'thold_alerting_header3' => array(
			'friendly_name' => __('SNMP Notification Options', 'thold'),
			'method' => 'spacer',
		),
		'thold_alert_snmp' => array(
			'friendly_name' => __('SNMP Notifications', 'thold'),
			'description' => __('Threshold status messages (informs/traps) will be sent to SNMP notification receivers. This includes Alerts, Warnings and Restoration traps per default. Note: This feature requires the Cacti SNMPAgent plugin.', 'thold'),
			'method' => 'checkbox',
			'default' => '0',
		),
		'thold_alert_snmp_warning' => array(
			'friendly_name' => __('Disable Warning Notifications', 'thold'),
			'description' => __('If this is checked, Threshold will not send a notification when a warning Threshold has been breached.', 'thold'),
			'method' => 'checkbox'
		),
		'thold_alert_snmp_normal' => array(
			'friendly_name' => __('Disable Restoration Notifications', 'thold'),
			'description' => __('If this is checked, Threshold will not send a notification when the Threshold has returned to normal status.', 'thold'),
			'method' => 'checkbox'
		),
		'thold_email_header' => array(
			'friendly_name' => __('Emailing Options', 'thold'),
			'method' => 'spacer',
		),
		'thold_email_prio' => array(
			'friendly_name' => __('Send Emails with Urgent Priority', 'thold'),
			'description' => __('Allows you to set Emails with urgent priority', 'thold'),
			'method' => 'checkbox',
			'default' => ''
		),
		'thold_send_text_only' => array(
			'friendly_name' => __('Send Alerts as Text', 'thold'),
			'description' => __('If checked, this will cause all Alerts to be sent as plain text Emails with no graph.  The default is HTML Emails with the graph embedded in the Email.', 'thold'),
			'method' => 'checkbox',
			'default' => ''
		),
		'thold_send_email_separately' => array(
			'friendly_name' => __('Send Email separately for each address', 'thold'),
			'description' => __('If checked, this will cause all Emails to be sent separately for each address.', 'thold'),
			'method' => 'checkbox',
			'default' => ''
		),
		'thold_from_email' => array(
			'friendly_name' => __('From Email Address', 'thold'),
			'description' => __('This is the Email address that the Threshold will appear from.', 'thold'),
			'method' => 'textbox',
			'default' => read_config_option('settings_from_email'),
			'max_length' => 255,
		),
		'thold_from_name' => array(
			'friendly_name' => __('From Name', 'thold'),
			'description' => __('This is the actual name that the Threshold will appear from.', 'thold'),
			'method' => 'textbox',
			'default' => read_config_option('settings_from_name'),
			'max_length' => 255,
		),
		'thold_device_header' => array(
			'friendly_name' => __('Device Notification Options', 'thold'),
			'method' => 'spacer',
		),
		'alert_deadnotify' => array(
			'friendly_name' => __('Device Notifications', 'thold'),
			'description' => __('Enable Dead/Recovering host notification', 'thold'),
			'method' => 'checkbox',
			'default' => 'on'
		),
		'alert_email' => array(
			'friendly_name' => __('Device Notifications Email', 'thold'),
			'description' => __('This is the Email Address that the Dead Device Notifications will be sent to if the Global Notification List is selected.', 'thold'),
			'method' => 'textbox',
			'size' => 80,
			'max_length' => 255,
		),
		'thold_down_subject' => array(
			'friendly_name' => __('Down Subject', 'thold'),
			'description' => __('This is the Email subject that will be used for Down Device Messages.', 'thold'),
			'method' => 'textbox',
			'size' => 100,
			'max_length' => 255,
			'default' => __('Device Error: <DESCRIPTION> (<HOSTNAME>) is DOWN', 'thold'),
		),
		'thold_down_text' => array(
			'friendly_name' => __('Down Message', 'thold'),
			'description' => __('This is the message that will be displayed as the message body of all UP / Down Device Messages (1024 Char MAX).  HTML is allowed, but will be removed for text only Emails.  There are several common replacement tags that may be used in include:<br>&#060HOSTNAME&#062 &#060HOST_ID&#062 &#060DESCRIPTION&#062 &#060UPTIME&#062 &#060UPTIMETEXT&#062 &#060DOWNTIME&#062 &#060TIME&#062 &#060DATE&#062 &#060DATE_RFC822&#062 &#060BREACHED_ITEMS&#062 &#060MESSAGE&#062 &#060SUBJECT&#062 &#060DOWN/UP&#062 &#060SNMP_HOSTNAME&#062 &#060SNMP_LOCATION&#062 &#060SNMP_CONTACT&#062 &#060SNMP_SYSTEM&#062 &#060LAST_FAIL&#062 &#060AVAILABILITY&#062 &#060TOT_POLL&#062 &#060FAIL_POLL&#062 &#060CUR_TIME&#062 &#060AVG_TIME&#062 &#060NOTES&#062', 'thold'),
			'method' => 'textarea',
			'class' => 'textAreaNotes',
			'textarea_rows' => '7',
			'textarea_cols' => '80',
			'default' => __('System Error : <DESCRIPTION> (<HOSTNAME>) is <DOWN/UP><br>Reason: <MESSAGE><br><br>Average system response: <AVG_TIME> ms<br>System availability: <AVAILABILITY><br>Total Checks Since Clear: <TOT_POLL><br>Total Failed Checks: <FAIL_POLL><br>Last Date Checked DOWN : <LAST_FAIL><br>Device Previously UP for: <DOWNTIME><br>NOTES: <NOTES><br>Device NOTES: <DNOTES>', 'thold'),
		),
		'thold_up_subject' => array(
			'friendly_name' => __('Recovering Subject', 'thold'),
			'description' => __('This is the Email subject that will be used for Recovering Device Messages.', 'thold'),
			'method' => 'textbox',
			'size' => 100,
			'max_length' => 255,
			'default' => __('Device Notice: <DESCRIPTION> (<HOSTNAME>) returned from DOWN state', 'thold'),
		),
		'thold_up_text' => array(
			'friendly_name' => __('Recovering Message', 'thold'),
			'description' => __('This is the message that will be displayed as the message body of all UP / Down Device Messages (1024 Char MAX).  HTML is allowed, but will be removed for text only Emails.  There are several common replacement tags that may be used in include:<br>&#060HOSTNAME&#062 &#060HOST_ID&#062 &#060DESCRIPTION&#062 &#060UPTIME&#062 &#060UPTIMETEXT&#062 &#060DOWNTIME&#062 &#060TIME&#062 &#060DATE&#062 &#060DATE_RFC822&#062 &#060BREACHED_ITEMS&#062  &#060MESSAGE&#062 &#060SUBJECT&#062 &#060DOWN/UP&#062 &#060SNMP_HOSTNAME&#062 &#060SNMP_LOCATION&#062 &#060SNMP_CONTACT&#062 &#060SNMP_SYSTEM&#062 &#060LAST_FAIL&#062 &#060AVAILABILITY&#062 &#060TOT_POLL&#062 &#060FAIL_POLL&#062 &#060CUR_TIME&#062 &#060AVG_TIME&#062 &#060NOTES&#062', 'thold'),
			'method' => 'textarea',
			'class' => 'textAreaNotes',
			'textarea_rows' => '7',
			'textarea_cols' => '80',
			'default' => __('<br>System <DESCRIPTION> (<HOSTNAME>) status: <DOWN/UP><br><br>Current ping response: <CUR_TIME> ms<br>Average system response: <AVG_TIME> ms<br>System availability: <AVAILABILITY><br>Total Checks Since Clear: <TOT_POLL><br>Total Failed Checks: <FAIL_POLL><br>Last Date Checked UP: <LAST_FAIL><br>Device Previously DOWN for: <DOWNTIME><br><br>Snmp Info:<br>Name - <SNMP_HOSTNAME><br>Location - <SNMP_LOCATION><br>Uptime - <UPTIMETEXT> (<UPTIME> ms)<br>System - <SNMP_SYSTEM><br><br>NOTE: <NOTES><br>Device Notes: <DNOTES>', 'thold'),
		),
		'thold_device_command' => array(
			'friendly_name' => __('Status Change Command', 'thold'),
			'description' => __('When a Device changes state from a Cacti perspective (UP to DOWN or DOWN to RECOVERING/UP), run the following command.  This command must NOT include command line arguments.  However, the following variables can be pulled from the environment of the script:<br>&#060THOLD_HOSTNAME&#062 &#060THOLD_HOST_ID&#062 &#060THOLD_DESCRIPTION&#062 &#060THOLD_UPTIME&#062 &#060THOLD_UPTIMETEXT&#062 &#060THOLD_DOWNTIME&#062 &#060THOLD_TIME&#062 &#060THOLD_DATE&#062 &#060THOLD_DATE_RFC822&#062 &#060THOLD_BREACHED_ITEMS&#062 &#060THOLD_MESSAGE&#062 &#060THOLD_SUBJECT&#062 &#060THOLD_DOWNUP&#062 &#060THOLD_SNMP_HOSTNAME&#062 &#060THOLD_SNMP_LOCATION&#062 &#060THOLD_SNMP_CONTACT&#062 &#060THOLD_SNMP_SYSTEM&#062 &#060THOLD_LAST_FAIL&#062 &#060THOLD_AVAILABILITY&#062 &#060THOLD_TOT_POLL&#062 &#060THOLD_FAIL_POLL&#062 &#060THOLD_CUR_TIME&#062 &#060THOLD_AVG_TIME&#062 &#060THOLD_NOTES&#062', 'thold'),
			'method' => 'filepath',
			'file_type' => 'binary',
			'size' => '100',
			'max_length' => '100',
			'default' => ''
		),
		'thold_notify_header' => array(
			'friendly_name' => __('Alert/Warning Message Defaults', 'thold'),
			'method' => 'spacer',
		),
		'thold_alert_text' => array(
			'friendly_name' => __('Threshold Alert Message', 'thold'),
			'description' => __('This is the message that will be displayed at the top of all Threshold Alerts (1024 Char MAX).  HTML is allowed, but will be removed for text only Emails.  There are several common replacement tags that may be used in include:<br>&#060DESCRIPTION&#062 &#060HOSTNAME&#062 &#060HOST_ID&#062 &#060TIME&#062 &#060DATE&#062 &#060DATE_RFC822&#062 &#060BREACHED_ITEMS&#062  &#060URL&#062 &#060GRAPHID&#062 &#060CURRENTVALUE&#062 &#060THRESHOLDNAME&#062  &#060DSNAME&#062 &#060SUBJECT&#062 &#060GRAPH&#062 &#60NOTES&#62 &#060DNOTES&#062', 'thold'),
			'method' => 'textarea',
			'class' => 'textAreaNotes',
			'textarea_rows' => '5',
			'textarea_cols' => '80',
			'default' => __('An Alert has been issued that requires your attention. <br><br><strong>Device</strong>: <DESCRIPTION> (<HOSTNAME>)<br><strong>URL</strong>: <URL><br><strong>Message</strong>: <SUBJECT><br><br><GRAPH>', 'thold'),
		),
		'thold_warning_text' => array(
			'friendly_name' => __('Threshold Warning Message', 'thold'),
			'description' => __('This is the message that will be displayed at the top of all Threshold warnings (1024 Char MAX).  HTML is allowed, but will be removed for text only Emails.  There are several common replacement tags that may be used in include:<br>&#060DESCRIPTION&#062 &#060HOSTNAME&#062 &#060HOST_ID&#062 &#060TIME&#062 &#060DATE&#062 &#060DATE_RFC822&#062 &#060BREACHED_ITEMS&#062  &#060URL&#062 &#060GRAPHID&#062 &#060CURRENTVALUE&#062 &#060THRESHOLDNAME&#062  &#060DSNAME&#062 &#060SUBJECT&#062 &#060GRAPH&#062 &#60NOTES&#62 &#060DNOTES&#062', 'thold'),
			'method' => 'textarea',
			'class' => 'textAreaNotes',
			'textarea_rows' => '5',
			'textarea_cols' => '80',
			'default' => __('A Warning has been issued that requires your attention. <br><br><strong>Device</strong>: <DESCRIPTION> (<HOSTNAME>)<br><strong>URL</strong>: <URL><br><strong>Message</strong>: <SUBJECT><br><br><GRAPH>', 'thold'),
		),
		'thold_restoral_text' => array(
			'friendly_name' => __('Threshold Restoral Message', 'thold'),
			'description' => __('This is the message that will be displayed at the top of all Threshold restoral notifications (1024 Chars MAX).  HTML is allowed, but will be removed for text only Emails.  There are several common replacement tags that may be used in include:<br>&#060DESCRIPTION&#062 &#060HOSTNAME&#062 &#060HOST_ID&#062 &#060TIME&#062 &#060DATE&#062 &#060DATE_RFC822&#062 &#060BREACHED_ITEMS&#062  &#060URL&#062 &#060GRAPHID&#062 &#060CURRENTVALUE&#062 &#060THRESHOLDNAME&#062  &#060DSNAME&#062 &#060SUBJECT&#062 &#060GRAPH&#062 &#60NOTES&#62 &#060DNOTES&#062', 'thold'),
			'method' => 'textarea',
			'class' => 'textAreaNotes',
			'textarea_rows' => '5',
			'textarea_cols' => '80',
			'default' => __('A Threshold has returned to normal status. <br><br><strong>Device</strong>: <DESCRIPTION> (<HOSTNAME>)<br><strong>URL</strong>: <URL><br><strong>Message</strong>: <SUBJECT><br><br><GRAPH>', 'thold'),
		),
	);

	if (isset($temp)) {
		$settings['alerts'] = array_merge($settings['alerts'], $temp);
	}
}

